IF  NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_CPL_ACERTO_CUSTO]') AND name = N'IDX_UK_EST_PROD_CPL_ACERTO_CUSTO_DT_MOV')
BEGIN 
	IF  OBJECT_ID('TEMPDB.DBO.#TMP_DEL_B') IS NOT NULL
	BEGIN
			DROP TABLE #TMP_DEL_B
	END

	IF  OBJECT_ID('TEMPDB.DBO.#TMP_DEL_A') IS NOT NULL
	BEGIN
		DROP TABLE #TMP_DEL_A
	END 

	SELECT
		DT_MOV,
		CD_PROD,
		CD_FILIAL
		INTO #TMP_DEL_A
	FROM
		EST_PROD_CPL_ACERTO_CUSTO   
	GROUP BY 
		DT_MOV,
		CD_PROD,
		CD_FILIAL 
	HAVING COUNT(*)  >1;

	SELECT
		A.DT_MOV,
		A.CD_PROD,
		A.CD_FILIAL,
		MAX(A.CD_CTR) CD_FICA
		INTO #TMP_DEL_B
	FROM
		EST_PROD_CPL_ACERTO_CUSTO A   
		INNER JOIN #TMP_DEL_A D ON 
		A.DT_MOV= D.DT_MOV AND
		A.CD_PROD=D.CD_PROD AND
		A.CD_FILIAL =D.CD_FILIAL  
	GROUP BY 
		A.DT_MOV,
		A.CD_PROD,
		A.CD_FILIAL

	DELETE FROM A
	FROM
		EST_PROD_CPL_ACERTO_CUSTO A   
		INNER JOIN #TMP_DEL_B D ON 
		A.DT_MOV= D.DT_MOV AND
		A.CD_PROD=D.CD_PROD AND
		A.CD_FILIAL =D.CD_FILIAL  
		AND A.CD_CTR <> D.CD_FICA 
	 
	IF  OBJECT_ID('TEMPDB.DBO.#TMP_DEL_B') IS NOT NULL
	BEGIN
			DROP TABLE #TMP_DEL_B
	END

	IF  OBJECT_ID('TEMPDB.DBO.#TMP_DEL_A') IS NOT NULL
	BEGIN
			DROP TABLE #TMP_DEL_A
	END

	CREATE UNIQUE NONCLUSTERED INDEX IDX_UK_EST_PROD_CPL_ACERTO_CUSTO_DT_MOV
	ON [dbo].[EST_PROD_CPL_ACERTO_CUSTO] ([DT_MOV],[CD_PROD],[CD_FILIAL],[CD_EMP])
	INCLUDE ([CD_CTR])

END	